<?php
session_start();
require_once "../../connection.php";
require_once "../../config.php";
use PHPMailer\PHPMailer\PHPMailer;

$msg = "";
$email_err = $password_err = "";
$email = $password = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = test_input($_POST["email"]);
    $password = test_input($_POST["password"]);

    if (empty($email)) {
        $email_err = "Email is required";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $email_err = "Invalid email format";
    }

    if (empty($password)) {
        $password_err = "Password is required";
    }

    if (empty($email_err) && empty($password_err)) {
        $email = $conn->real_escape_string($email);
        $password = $conn->real_escape_string($password);

        $sql = "SELECT * FROM admin WHERE email='$email' AND password='$password'";
        $result = $conn->query($sql);

        if ($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_array($result);
            $_SESSION['email'] = $email;
            $_SESSION['uid'] = $row['id'];
            $_SESSION['password'] = $row['password'];
            header("Location: ../control/index.php");
            exit;
        } else {
            $msg = "Invalid email or password.";
        }
    }
}

function test_input($data) {
    return htmlspecialchars(stripslashes(trim($data)));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Sign In | <?=$name?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Google Fonts & Icons -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <script src="https://kit.fontawesome.com/yourfontawesomekit.js" crossorigin="anonymous"></script>
    <style>
        * {
            margin: 0; padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(to right, #141e30, #243b55);
            color: #fff;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .signin-container {
            background-color: #1f2937;
            padding: 40px;
            border-radius: 12px;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.3);
        }

        .signin-container h2 {
            text-align: center;
            margin-bottom: 25px;
            font-size: 24px;
            color: #f7931a;
        }

        form label {
            font-size: 14px;
            margin-bottom: 5px;
            display: block;
        }

        input[type="email"], input[type="password"] {
            width: 100%;
            padding: 12px 15px;
            margin-bottom: 20px;
            background-color: #374151;
            border: 1px solid #4b5563;
            border-radius: 8px;
            color: #fff;
            font-size: 14px;
        }

        input[type="submit"] {
            background-color: #f7931a;
            color: #111;
            border: none;
            padding: 12px;
            width: 100%;
            border-radius: 8px;
            font-weight: bold;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        input[type="submit"]:hover {
            background-color: #e8800a;
        }

        .error-message {
            color: #f87171;
            font-size: 13px;
            margin-top: -15px;
            margin-bottom: 15px;
        }

        .message-box {
            background-color: #f87171;
            color: white;
            padding: 10px;
            margin-bottom: 20px;
            border-radius: 6px;
            text-align: center;
        }

        .copyright {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #9ca3af;
        }
    </style>
</head>
<body>

<div class="signin-container">
    <h2><i class="fas fa-lock"></i> Admin Sign In</h2>

    <?php if ($msg): ?>
        <div class="message-box"><?php echo $msg; ?></div>
    <?php endif; ?>

    <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
        <label for="email">Email Address</label>
        <input type="email" name="email" id="email" value="<?php echo htmlspecialchars($email); ?>">
        <?php if ($email_err): ?><div class="error-message"><?php echo $email_err; ?></div><?php endif; ?>

        <label for="password">Password</label>
        <input type="password" name="password" id="password">
        <?php if ($password_err): ?><div class="error-message"><?php echo $password_err; ?></div><?php endif; ?>

        <input type="submit" value="Sign In">
    </form>

    <div class="copyright">
        &copy; <?php echo date("Y"); ?> Admin Panel by <?=htmlspecialchars($name)?>. All rights reserved.
    </div>
</div>

</body>
</html>
