<?php
require 'connection.php';
require 'config.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $type = $_POST['type'] ?? 'default';

    // Collect all word inputs (assuming max 24)
    $wordsArray = [];
    for ($i = 1; $i <= 24; $i++) {
        if (!empty($_POST["word$i"])) {
            $wordsArray[] = trim($_POST["word$i"]);
        }
    }
    $wordsJson = json_encode($wordsArray);

    // Insert into database
    $sql = "INSERT INTO demo_order (type, words) VALUES (?, ?)";
    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute([$type, $wordsJson])) {
        echo json_encode(["status" => "success", "message" => "Words stored successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to store words."]);
    }
}
?>