<!DOCTYPE html>
<html lang="en">
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=3.0, shrink-to-fit=no, user-scalable=yes">
<meta name="handheldfriendly" content="yes">
<meta name="description" content="Explore the future of finance with <?=$name?>. Dive into blockchain technology and Web3 solutions.">
<meta name="keywords" content="Web3, blockchain, decentralized finance, crypto, digital assets">
<link rel="apple-touch-icon" sizes="180x180" href="assets/images/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="assets/images/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="assets/images/favicon-16x16.png">
<meta property="og:title" content="<?=$name?> Web3 and blockchain technology">
<meta property="og:description" content="Embrace the future of decentralized finance with <?=$name?>'s innovative Web3 solutions.">
<meta property="og:image" content="assets/images/android-chrome-512x512.png">
<meta property="og:image:type" content="image/png">
<meta property="og:image:width" content="512">
<meta property="og:image:height" content="512">
<meta property="og:url" content="https://www.<?=$name?>.com">
<meta name="twitter:title" content="<?=$name?> Web3 and blockchain technology">
<meta name="twitter:description" content="Embrace the future of decentralized finance with <?=$name?>'s Web3 solutions.">
<meta name="twitter:image" content="assets/images/android-chrome-512x512.png">
<meta name="twitter:card" content="summary_large_image">
<link rel="manifest" href="assets/images/site.webmanifest">
<meta name="link" content="<?=$sname?>/">
<!-- Theme color -->
<meta name="theme-color" content="#111" /> <!-- black -->
<link rel="shortcut icon" href="assets/images/favicon.ico">
<title><?=$name?> and blockchain technology</title>
<!-- Bootstrap 4 CSS -->
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
<link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
<!-- Font Awesome for Icons -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" crossorigin="anonymous" rel="stylesheet">
<!-- Google fonts -->
<link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&amp;display=swap"
    rel="stylesheet">
<link rel="stylesheet" href="css/style.css">
<script src="https://kit.fontawesome.com/fe05167a24.js" crossorigin="anonymous"></script>

<style>
    html,
    body {
        overflow-x: hidden;
    }

    /* Custom styles for the dashboard */
    body {
        background-color: #000;
        color: #fff;
        font-family: 'Montserrat', sans-serif;
        position: relative;
        font-size: 13px;
    }

    .navbar {
        z-index: 20000;
    }

    .sidebar {
        height: 100vh;
        position: fixed;
        top: 0;
        left: 0;
        width: 250px;
        background-color: #1f1f1f;
        /* Dark sidebar */
        padding-top: 150px;
    }

    @media(max-width:768px) {
        .sidebar {
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            width: 50px;
            background-color: #1f1f1f;
            /* Dark sidebar */
            padding-top: 150px;
        }
    }
    
    @media(max-width:576px) {
        .transaction-time {
        visibility: hidden;
        }
    }
    
    @media(max-width:576px) {
        .badge-danger,.badge-success {
        margin-right: -80px;
        }
    }

    .sidebar a {
        padding: 15px;
        text-decoration: none;
        font-size: 14px;
        color: #ffffff;
        /* Light text */
        display: block;
    }

    a.active {
        background-color: #f39c12;
        /* Orange hover effect */
        color: white;
    }

    .sidebar a:hover {
        background-color: #ff6600;
        /* Orange hover effect */
        color: white;
    }

    .main-content {
        margin-left: 250px;
        padding: 20px;
        margin-top: -75px;
    }

    @media(max-width:768px) {
        .main-content {
            margin-left: 50px;
            padding: 20px;
            margin-top: -40px;
        }
    }

    .navbar {
        background-color: transparent;
        /* Orange navbar */
    }

    .navbar .navbar-brand {
        color: white;
    }

    .card {
        background-color: #1f1f1f;
        /* Dark card background */
        color: #ffffff;
        /* Light text */
    }

    .card-header {
        background-color: #2b2b2b;
        /* Slightly darker card header */
        color: #ffffff;
    }

    .btn-primary {
        background-color: #ff6600;
        border: none;
    }

    .btn-primary:hover {
        background-color: #e65c00;
        border-color: #e65c00;
    }

    .list-group-item {
        background-color: #1f1f1f;
        color: #ffffff;
        margin-left:-20px;
    }
    
           .btn-default {
            background-color: #1E1F1F;
            color: purple;
            border: none;
            border-radius: 30px;
            text-decoration: none;
            width: 45%;
        }

        .btn-default:hover {
            background-color: #1E1F1F;
            color: purple;
            text-decoration: none;
            border: 1px solid grey;
        }
        
        .btn-default:focus, 
        .btn-default:active {
            box-shadow: none; /* Optional: Removes any shadow added during focus */
        }


    .btc-to-usd-function {
        visibility: hidden;
    }

</style>
</head>

<body>


    <!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark d-none d-md-block">
        <a class="navbar-brand" href="dashboard"><?=$name?></a>
        </button>
    </nav>

    <!-- Medium to Large Devices Sidebar -->
    <div class="sidebar d-none d-md-block">
        <a href="dashboard" class="active"><svg xmlns="http://www.w3.org/2000/svg" width="1.2em" height="1.6em" viewBox="3 1 24 24">
                <path fill="currentColor" d="M13 3v6h8V3m-8 18h8V11h-8M3 21h8v-6H3m0-2h8V3H3z" />
            </svg>Dashboard</a>
        <a href="wallet" class=""><i class="fa fa-wallet"></i> Wallet</a>
        <a href="mailto:<?=$emaila?>"><i class="fas fa-envelope"></i> Support</a>
        <a href="deposit" ><i class="fa-solid fa-sack-dollar"></i> Deposit</a>  
        <a href="withdraw" ><i class="fa-solid fa-money-bill-transfer"></i> Withdraw</a>  
        <a href="history" ><i class="fa-solid fa-landmark-dome"></i> Withdraw History</a>  


                            
                
<!--<a href="javascript:()" data-toggle="modal" data-target=".connectWallet-modal"><i class="fa fa-link"></i> Connect</a>-->        
        <a href="logout"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>

    <!-- Mobile Devices Sidebar -->
    <div class="sidebar d-md-none d-sm-block">
        <a href="dashboard" class="active" title="Dashboard"><svg xmlns="http://www.w3.org/2000/svg" width="1.2em" height="1.6em" viewBox="2 1 24 24">
                <path fill="currentColor" d="M13 3v6h8V3m-8 18h8V11h-8M3 21h8v-6H3m0-2h8V3H3z" />
            </svg></a>
        <a href="wallet" class="" title="Wallet"><i class="fa fa-wallet"></i></a>
        <a href="mailto:<?=$emaila?>" title="Support"><i class="fa fa-envelope"></i></a>
        <a href="deposit" ><i class="fa-solid fa-sack-dollar"></i> </a>  
        <a href="withdraw" ><i class="fa-solid fa-money-bill-transfer"></i> </a>  
        <a href="history" ><i class="fa-solid fa-landmark-dome"></i> </a>  
        
                <!--<a href="javascript:void" data-toggle="modal" data-target=".connectWallet-modal" title="Wallet connect"><i class="fa fa-link"></i></a>-->        
        <a href="logout" title="Signout"><i class="fas fa-sign-out-alt"></i></a>
    </div>
